﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Menu.Sample1
{
    public partial class MainForm : Form
    {
        [DllImport("user32.dll")]
        private static extern IntPtr CreateMenu();

        [DllImport("user32.dll")]
        private static extern bool DrawMenuBar(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern bool SetMenu(IntPtr hWnd, IntPtr hMenu);

        [DllImport("user32.dll", EntryPoint = "AppendMenuA")]
        public static extern bool AppendMenu(IntPtr hMenu, MenuFlags wFlags, IntPtr wIDNewItem, string lpNewItem);

        [Flags]
        public enum MenuFlags : uint
        {
            MF_Checked = 0x8,
            MF_Disabled = 0x2,
            MF_Grayed = 0x1,
            MF_Separator = 0x800,
            MF_String = 0x0,
            MF_Enabled = 0x0
        }

        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            IntPtr hMenu = CreateMenu();
            IntPtr hWnd = this.Handle;
            SetMenu(hWnd, hMenu);
            AppendMenu(hMenu, MenuFlags.MF_String, new IntPtr(1001), "Salam !");
            AppendMenu(hMenu, MenuFlags.MF_Grayed | MenuFlags.MF_Disabled, new IntPtr(1002), "Saber");
            AppendMenu(hMenu, MenuFlags.MF_Checked, new IntPtr(1003), "Fathollahi");
            DrawMenuBar(hWnd);
        }
    }
}